/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.data.ClientFrameData;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.client.gui.DrawUtils;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import net.puffish.skillsmod.utils.Vec2i;

public class SkillsScreen
extends Screen {
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("textures/gui/advancements/tabs.png");
    private static final ResourceLocation WINDOW_TEXTURE = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/advancements/widgets.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int LINE_WIDTH = 170;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private final List<ClientSkillCategoryData> categories;
    private int activeCategory = 0;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private float scale = 1.0f;
    private int x = 0;
    private int y = 0;
    private boolean dragging;
    private Bounds2i bounds;
    private double dragStartX;
    private double dragStartY;
    private boolean small;
    private int contentPaddingTop;
    private int contentPaddingLeft;
    private int contentPaddingRight;
    private int contentPaddingBottom;
    private List<FormattedCharSequence> tooltip;

    public SkillsScreen(List<ClientSkillCategoryData> categories) {
        super(CommonComponents.f_237098_);
        this.categories = categories;
    }

    private ClientSkillCategoryData getActiveCategory() {
        return this.categories.get(this.activeCategory);
    }

    private void setActiveCategory(int activeCategory) {
        this.activeCategory = activeCategory;
        this.resize();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.resize();
    }

    private void resize() {
        boolean bl = this.small = this.f_96543_ < 450;
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        this.x = this.f_96543_ / 2;
        this.y = this.f_96544_ / 2;
        this.bounds = this.getActiveCategory().getBounds();
        this.bounds.grow(32);
        this.bounds.extend(new Vec2i(this.contentPaddingLeft - this.x, this.contentPaddingTop - this.y));
        this.bounds.extend(new Vec2i(this.f_96543_ - this.x - this.contentPaddingRight, this.f_96544_ - this.y - this.contentPaddingBottom));
        int contentWidth = this.f_96543_ - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.f_96544_ - this.contentPaddingTop - this.contentPaddingBottom;
        int halfWidth = Mth.m_184652_((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
        int halfHeight = Mth.m_184652_((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
        this.bounds.extend(new Vec2i(-halfWidth, -halfHeight));
        this.bounds.extend(new Vec2i(halfWidth, halfHeight));
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.scale = 1.0f;
    }

    private Vec2i getMousePos(double mouseX, double mouseY) {
        return new Vec2i((int)mouseX, (int)mouseY);
    }

    private Vec2i getTransformedMousePos(double mouseX, double mouseY) {
        return new Vec2i((int)Math.round((mouseX - (double)this.x) / (double)this.scale), (int)Math.round((mouseY - (double)this.y) / (double)this.scale));
    }

    private boolean isInsideTab(Vec2i mouse, int i) {
        return mouse.x >= 8 + i * 32 && mouse.y >= 8 && mouse.x < 8 + i * 32 + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vec2i transformedMouse, ClientSkillData skill, ClientSkillDefinitionData definition) {
        int halfSize = Math.round(13.0f * definition.getSize());
        return transformedMouse.x >= skill.getX() - halfSize && transformedMouse.y >= skill.getY() - halfSize && transformedMouse.x < skill.getX() + halfSize && transformedMouse.y < skill.getY() + halfSize;
    }

    private boolean isInsideContent(Vec2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.f_96543_ - this.contentPaddingRight && mouse.y < this.f_96544_ - this.contentPaddingBottom;
    }

    private boolean isInsideExperience(Vec2i mouse, int x, int y) {
        return mouse.x >= x && mouse.y >= y && mouse.x < x + 182 && mouse.y < y + 5;
    }

    private boolean isInsideArea(Vec2i mouse, int x1, int y1, int x2, int y2) {
        return mouse.x >= x1 && mouse.y >= y1 && mouse.x < x2 && mouse.y < y2;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Vec2i mouse = this.getMousePos(mouseX, mouseY);
        Vec2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            for (ClientSkillData skill : this.getActiveCategory().getSkills().values()) {
                ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill.getDefinitionId());
                if (definition == null || !this.isInsideSkill(transformedMouse, skill, definition)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(SkillClickOutPacket.write(this.getActiveCategory().getId(), skill.getId()));
            }
            if (button == 0) {
                this.dragStartX = mouseX - (double)this.x;
                this.dragStartY = mouseY - (double)this.y;
                this.dragging = true;
            }
        } else {
            this.dragging = false;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!this.isInsideTab(mouse, i)) continue;
            this.setActiveCategory(i);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        this.m_7333_(matrices);
        this.drawContent(matrices, mouseX, mouseY);
        this.drawWindow(matrices, mouseX, mouseY);
        this.drawTabs(matrices, mouseX, mouseY);
        if (this.tooltip != null) {
            this.m_96617_(matrices, this.tooltip, mouseX, mouseY);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.x = (int)Math.round(mouseX - this.dragStartX);
            this.y = (int)Math.round(mouseY - this.dragStartY);
            this.limitPosition();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        float factor = (float)Math.pow(2.0, amount * 0.25);
        this.scale *= factor;
        if (this.scale < this.minScale) {
            this.scale = this.minScale;
            factor = this.minScale / this.scale;
        }
        if (this.scale > this.maxScale) {
            this.scale = this.maxScale;
            factor = this.maxScale / this.scale;
        }
        this.x -= (int)Math.round((double)(factor - 1.0f) * (mouseX - (double)this.x));
        this.y -= (int)Math.round((double)(factor - 1.0f) * (mouseY - (double)this.y));
        this.limitPosition();
        return super.m_6050_(mouseX, mouseY, amount);
    }

    private void limitPosition() {
        this.y = Math.min(this.y, Math.round((float)this.contentPaddingTop - (float)this.bounds.min().y * this.scale));
        this.x = Math.min(this.x, Math.round((float)this.contentPaddingLeft - (float)this.bounds.min().x * this.scale));
        this.x = Math.max(this.x, Math.round((float)(this.f_96543_ - this.contentPaddingRight) - (float)this.bounds.max().x * this.scale));
        this.y = Math.max(this.y, Math.round((float)(this.f_96544_ - this.contentPaddingBottom) - (float)this.bounds.max().y * this.scale));
    }

    private void drawIcon(PoseStack matrices, ClientIconData icon, float sizeScale, int x, int y) {
        if (this.f_96541_ == null) {
            return;
        }
        if (icon instanceof ClientIconData.ItemIconData) {
            ClientIconData.ItemIconData itemIcon = (ClientIconData.ItemIconData)icon;
            matrices.m_85836_();
            matrices.m_85837_((double)((float)x * (1.0f - sizeScale)), (double)((float)y * (1.0f - sizeScale)), 0.0);
            matrices.m_85841_(sizeScale, sizeScale, 1.0f);
            DrawUtils.drawItem(matrices, x - 8, y - 8, itemIcon.getItem());
            matrices.m_85849_();
        } else if (icon instanceof ClientIconData.EffectIconData) {
            ClientIconData.EffectIconData effectIcon = (ClientIconData.EffectIconData)icon;
            TextureAtlasSprite sprite = this.f_96541_.m_91306_().m_118732_(effectIcon.getEffect());
            int halfSize = Math.round(9.0f * sizeScale);
            int size = halfSize * 2;
            RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
            DrawUtils.drawSingleSprite(matrices, x - halfSize, y - halfSize, size, size, sprite);
        } else if (icon instanceof ClientIconData.TextureIconData) {
            ClientIconData.TextureIconData textureIcon = (ClientIconData.TextureIconData)icon;
            int halfSize = Math.round(8.0f * sizeScale);
            int size = halfSize * 2;
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureIcon.getTexture());
            DrawUtils.drawSingleTexture(matrices, x - halfSize, y - halfSize, size, size);
        }
    }

    private void drawFrame(PoseStack matrices, ClientFrameData frame, float sizeScale, int x, int y, SkillState state) {
        if (this.f_96541_ == null) {
            return;
        }
        int halfSize = Math.round(13.0f * sizeScale);
        int size = halfSize * 2;
        if (frame instanceof ClientFrameData.AdvancementFrameData) {
            ClientFrameData.AdvancementFrameData advancementFrame = (ClientFrameData.AdvancementFrameData)frame;
            AdvancementWidgetType status = state == SkillState.UNLOCKED ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            switch (state) {
                case LOCKED: 
                case EXCLUDED: {
                    RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    break;
                }
                default: {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_TEXTURE);
            SkillsScreen.m_93160_((PoseStack)matrices, (int)(x - halfSize), (int)(y - halfSize), (int)size, (int)size, (float)advancementFrame.getFrame().m_15551_(), (float)(128 + status.m_97325_() * 26), (int)26, (int)26, (int)256, (int)256);
        } else if (frame instanceof ClientFrameData.TextureFrameData) {
            ClientFrameData.TextureFrameData textureFrame = (ClientFrameData.TextureFrameData)frame;
            ResourceLocation texture = switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case SkillState.AVAILABLE -> {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    yield textureFrame.getAvailableTexture();
                }
                case SkillState.UNLOCKED -> {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    yield textureFrame.getUnlockedTexture();
                }
                case SkillState.LOCKED -> {
                    if (textureFrame.getLockedTexture() != null) {
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        yield textureFrame.getLockedTexture();
                    }
                    RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    yield textureFrame.getAvailableTexture();
                }
                case SkillState.EXCLUDED -> {
                    if (textureFrame.getExcludedTexture() != null) {
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        yield textureFrame.getExcludedTexture();
                    }
                    RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    yield textureFrame.getAvailableTexture();
                }
            };
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
            SkillsScreen.m_93133_((PoseStack)matrices, (int)(x - halfSize), (int)(y - halfSize), (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
        }
    }

    private void drawContent(PoseStack matrices, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        Vec2i mouse = this.getMousePos(mouseX, mouseY);
        Vec2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)519);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 256.0);
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-16777216);
        matrices.m_85837_(0.0, 0.0, -512.0);
        GuiComponent.m_93172_((PoseStack)matrices, (int)(this.contentPaddingLeft - 4), (int)(this.contentPaddingTop - 4), (int)(this.f_96543_ - this.contentPaddingRight + 4), (int)(this.f_96544_ - this.contentPaddingBottom + 4), (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69456_((int)515);
        matrices.m_85837_((double)this.x, (double)this.y, 128.0);
        matrices.m_85841_(this.scale, this.scale, 1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getActiveCategory().getBackground());
        DrawUtils.drawRepeatedTexture(matrices, this.bounds.min().x, this.bounds.min().y, this.bounds.width(), this.bounds.height(), 0, 0, 16, 16);
        for (ClientSkillConnectionData connection : this.getActiveCategory().getNormalConnections()) {
            ClientSkillData skillA = this.getActiveCategory().getSkills().get(connection.getSkillAId());
            ClientSkillData skillB = this.getActiveCategory().getSkills().get(connection.getSkillBId());
            if (skillA == null || skillB == null) continue;
            this.drawConnection(matrices, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), !connection.isBidirectional(), 0xFFFFFF);
        }
        if (this.isInsideContent(mouse)) {
            Optional<ClientSkillData> optHoveredSkill = this.getActiveCategory().getSkills().values().stream().filter(skill -> {
                ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill.getDefinitionId());
                if (definition == null) {
                    return false;
                }
                return this.isInsideSkill(transformedMouse, (ClientSkillData)skill, definition);
            }).findFirst();
            optHoveredSkill.ifPresent(hoveredSkill -> {
                ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(hoveredSkill.getDefinitionId());
                if (definition == null) {
                    return;
                }
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(definition.getTitle().m_7532_());
                lines.addAll(this.f_96547_.m_92923_((FormattedText)ComponentUtils.m_130750_((MutableComponent)definition.getDescription().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY)), 170));
                if (Screen.m_96638_()) {
                    lines.addAll(this.f_96547_.m_92923_((FormattedText)ComponentUtils.m_130750_((MutableComponent)definition.getExtraDescription().m_6881_(), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY)), 170));
                }
                if (this.f_96541_.f_91066_.f_92125_) {
                    lines.add(Component.m_237113_((String)hoveredSkill.getId()).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                }
                this.tooltip = lines;
                Collection<ClientSkillConnectionData> connections = this.getActiveCategory().getExclusiveConnections().get(hoveredSkill.getId());
                if (connections != null) {
                    for (ClientSkillConnectionData connection : connections) {
                        ClientSkillData skillA = this.getActiveCategory().getSkills().get(connection.getSkillAId());
                        ClientSkillData skillB = this.getActiveCategory().getSkills().get(connection.getSkillBId());
                        if (skillA == null || skillB == null) continue;
                        this.drawConnection(matrices, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), !connection.isBidirectional(), 0xFF0000);
                    }
                }
            });
        }
        for (ClientSkillData skill2 : this.getActiveCategory().getSkills().values()) {
            ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill2.getDefinitionId());
            if (definition == null) continue;
            this.drawFrame(matrices, definition.getFrame(), definition.getSize(), skill2.getX(), skill2.getY(), skill2.getState());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawIcon(matrices, definition.getIcon(), definition.getSize(), skill2.getX(), skill2.getY());
        }
        matrices.m_85849_();
        matrices.m_85836_();
        RenderSystem.m_69456_((int)519);
        matrices.m_85837_(0.0, 0.0, -512.0);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69456_((int)515);
        matrices.m_85849_();
    }

    private void drawConnection(PoseStack matrices, float startX, float startY, float endX, float endY, boolean unidirectional, int rgb) {
        this.drawLine(matrices, startX, startY, endX, endY, 3, -16777216);
        if (unidirectional) {
            this.drawArrow(matrices, startX, startY, endX, endY, 8.0f, -16777216);
        }
        this.drawLine(matrices, startX, startY, endX, endY, 1, rgb | 0xFF000000);
        if (unidirectional) {
            this.drawArrow(matrices, startX, startY, endX, endY, 6.0f, rgb | 0xFF000000);
        }
    }

    private void drawLine(PoseStack matrices, float startX, float startY, float endX, float endY, int thickness, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        Vec2 tmp = new Vec2(endX, endY).m_165910_(new Vec2(-startX, -startY)).m_165902_();
        tmp = new Vec2(tmp.f_82471_, -tmp.f_82470_).m_165903_((float)thickness / 2.0f);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_85982_(matrix, startX + tmp.f_82470_, startY + tmp.f_82471_, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(matrix, startX - tmp.f_82470_, startY - tmp.f_82471_, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(matrix, endX - tmp.f_82470_, endY - tmp.f_82471_, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(matrix, endX + tmp.f_82470_, endY + tmp.f_82471_, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    private void drawArrow(PoseStack matrices, float startX, float startY, float endX, float endY, float thickness, int argb) {
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        Vec2 center = new Vec2(endX, endY).m_165910_(new Vec2(startX, startY)).m_165903_(0.5f);
        Vec2 normal = new Vec2(endX, endY).m_165910_(new Vec2(-startX, -startY)).m_165902_();
        Vec2 forward = new Vec2(normal.f_82470_, normal.f_82471_).m_165903_(thickness);
        Vec2 backward = new Vec2(forward.f_82470_, forward.f_82471_).m_165903_(-0.5f);
        Vec2 back = new Vec2(center.f_82470_, center.f_82471_).m_165910_(backward);
        Vec2 side = new Vec2(backward.f_82471_, -backward.f_82470_).m_165903_(Mth.m_14116_((float)3.0f));
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_85982_(matrix, center.f_82470_ + forward.f_82470_, center.f_82471_ + forward.f_82471_, 0.0f).m_193479_(argb).m_5752_();
        bufferBuilder.m_85982_(matrix, back.f_82470_ - side.f_82470_, back.f_82471_ - side.f_82471_, 0.0f).m_193479_(argb).m_5752_();
        bufferBuilder.m_85982_(matrix, back.f_82470_ + side.f_82470_, back.f_82471_ + side.f_82471_, 0.0f).m_193479_(argb).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    private void drawTabs(PoseStack matrices, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69465_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TABS_TEXTURE);
        for (int i = 0; i < this.categories.size(); ++i) {
            GuiComponent.m_93133_((PoseStack)matrices, (int)(8 + 32 * i), (int)8, (float)(i > 0 ? 28.0f : 0.0f), (float)(this.activeCategory == i ? 32.0f : 0.0f), (int)28, (int)32, (int)256, (int)256);
        }
        Vec2i mouse = this.getMousePos(mouseX, mouseY);
        for (int i = 0; i < this.categories.size(); ++i) {
            ClientSkillCategoryData category = this.categories.get(i);
            this.drawIcon(matrices, category.getIcon(), 1.0f, 8 + 32 * i + 6 + 8, 25);
            if (!this.isInsideTab(mouse, i)) continue;
            this.tooltip = this.f_96547_.m_92923_((FormattedText)category.getTitle(), 170);
        }
    }

    private void drawWindow(PoseStack matrices, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        Vec2i mouse = this.getMousePos(mouseX, mouseY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69465_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW_TEXTURE);
        GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)(this.f_96544_ - 8 - 70 + 1), (float)0.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)(this.f_96544_ - 8 - 70 + 1), (float)126.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        DrawUtils.drawScaledTexture(matrices, 8, 78, 126, this.f_96544_ - 16 - 140 + 1, 0, 69, 126, 2, 256, 256);
        DrawUtils.drawScaledTexture(matrices, 134, this.f_96544_ - 8 - 70 + 1, this.f_96543_ - 16 - 252 + 1, 70, 125, 70, 2, 70, 256, 256);
        DrawUtils.drawScaledTexture(matrices, this.f_96543_ - 8 - 126 + 1, 78, 126, this.f_96544_ - 16 - 140 + 1, 126, 69, 126, 2, 256, 256);
        if (this.small) {
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)52, (float)0.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)52, (float)126.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            DrawUtils.drawScaledTexture(matrices, 134, 36, this.f_96543_ - 16 - 252 + 1, 16, 125, 0, 2, 16, 256, 256);
            DrawUtils.drawScaledTexture(matrices, 134, 52, this.f_96543_ - 16 - 252 + 1, 54, 125, 8, 2, 54, 256, 256);
        } else {
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            DrawUtils.drawScaledTexture(matrices, 134, 36, this.f_96543_ - 16 - 252 + 1, 70, 125, 0, 2, 70, 256, 256);
        }
        MutableComponent tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)tmpX, (float)tmpY, -12566464);
        int leftX = tmpX + this.f_96547_.m_92852_((FormattedText)tmpText);
        int startX = tmpX = this.f_96543_ - 8 - 7;
        ClientSkillCategoryData activeCategory = this.getActiveCategory();
        tmpText = Component.m_237113_((String)(activeCategory.getPointsLeft() + (String)(activeCategory.getSpentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.getSpentPointsLeft())));
        tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText);
        DrawUtils.drawTextWithBorder(matrices, (Component)tmpText, --tmpX, tmpY, -16777216, -8323296);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)(tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText)), (float)tmpY, -12566464);
        Objects.requireNonNull(this.f_96547_);
        if (this.isInsideArea(mouse, tmpX, tmpY, startX, tmpY + 9)) {
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
            lines.add(SkillsMod.createTranslatable("tooltip", "earned_points", activeCategory.getEarnedPoints()).m_7532_());
            lines.add(SkillsMod.createTranslatable("tooltip", "spent_points", activeCategory.getSpentPoints() + (String)(activeCategory.getSpentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.getSpentPointsLimit())).m_7532_());
            this.tooltip = lines;
        }
        int rightX = tmpX;
        if (activeCategory.getCurrentLevel() >= 0) {
            if (this.small) {
                tmpX = this.f_96543_ - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (leftX + rightX - 182) / 2;
                tmpY = 43;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
            this.m_93228_(matrices, tmpX, tmpY, 0, 64, 182, 5);
            int width = Math.min(182, (int)(this.getActiveCategory().getExperienceProgress() * 183.0f));
            if (width > 0) {
                this.m_93228_(matrices, tmpX, tmpY, 0, 69, width, 5);
            }
            if (this.isInsideExperience(mouse, tmpX, tmpY)) {
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(SkillsMod.createTranslatable("tooltip", "current_level", activeCategory.getCurrentLevel()).m_7532_());
                lines.add(SkillsMod.createTranslatable("tooltip", "experience_progress", activeCategory.getCurrentExperience(), activeCategory.getRequiredExperience(), Mth.m_14143_((float)(activeCategory.getExperienceProgress() * 100.0f))).m_7532_());
                lines.add(SkillsMod.createTranslatable("tooltip", "to_next_level", activeCategory.getExperienceToNextLevel()).m_7532_());
                this.tooltip = lines;
            }
        }
    }
}

